#include <windows.h>
#include "GUI.h"
extern DWORD Monitor;

void DoPaint(HWND hWnd,GUICompo *GUI)
{
	PAINTSTRUCT Paint;
	HDC hDC,hBackgroundDC;
	RECT Rect;
	HBRUSH hBrush;
	LOGBRUSH Brush;
	HPEN hPen;
	HBITMAP hBitmap;
	DWORD Count;
	BYTE Color;

	hDC = BeginPaint(hWnd,&Paint);
	GetClientRect(hWnd,&Rect); 
	
	hBackgroundDC = CreateCompatibleDC(hDC);
	hBitmap = CreateCompatibleBitmap(hDC,Rect.right-Rect.left,Rect.bottom-Rect.top);
	hBitmap = SelectObject(hBackgroundDC,hBitmap);	
	
	Brush.lbColor = RGB(0,0,0);
	Brush.lbStyle = BS_SOLID;

	hBrush = CreateBrushIndirect(&Brush);
	FillRect(hBackgroundDC,&Rect,hBrush);
	if(!GUI->PaintedOnce)
	{
		FillRect(hDC,&Rect,hBrush);
		GUI->PaintedOnce = TRUE;
	}

	for(Count = 0 ; Count < NUMBER_OF_LINES ; Count++)
	{
		if(GUI->Lines[Count].IsVisible)
		{
			if(Count > (NUMBER_OF_LINES/2))
				Color = 255 - (BYTE)((double)(Count-(NUMBER_OF_LINES/2)) * (255/(NUMBER_OF_LINES/2)));
			else
				Color = (BYTE)((double)(Count) * (255/(NUMBER_OF_LINES/2)));

			hPen = CreatePen(PS_SOLID,0,RGB(Color,Color,Color));
			hPen = SelectObject(hBackgroundDC,hPen);

			MoveToEx(hBackgroundDC,GUI->Lines[Count].Points[0].x,GUI->Lines[Count].Points[0].y,NULL);
			LineTo(hBackgroundDC,GUI->Lines[Count].Points[1].x,GUI->Lines[Count].Points[1].y);

			DeleteObject(SelectObject(hBackgroundDC,hPen));
		}
	}

	BitBlt(hDC,Rect.left,Rect.top,Rect.right-Rect.left,Rect.bottom-Rect.top-WINDOW_BORDER/2+30,hBackgroundDC,Rect.left,Rect.top,SRCCOPY);
	DeleteObject(SelectObject(hBackgroundDC,hBitmap));	
	DeleteObject(hBrush);
	DeleteDC(hBackgroundDC);

	EndPaint(hWnd,&Paint);
	return;
}
